﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;


/* threads and exceptions 
   
   check the Program.cs where a general exception handler is installed 
   which handles unhandled exceptions thrown by UI threads */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }

        
        SynchronizationContext synContext;
        Thread t = null;

 

        /* the thread procedure 
           a thread procedure should be always guarded, regarding exceptions.
           Unhandled thread exceptions, after C# 2.0, terminate the application */
        void ThreadProc()
        {
            try
            {
                throw new ApplicationException("this is an exception thrown inside a thread");
            }
            catch (Exception ex)
            {
                synContext.Send(SynchronizedMethod, DateTime.Now + ", ERROR: " + ex.Message); 
            }
            
        }

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))
            {
                t = new Thread(ThreadProc);
                t.Start();
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            throw new ApplicationException("this is exception is thrown inside a UI thread");
        }
    }
}
